/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.loot.modifier;

import com.google.gson.JsonObject;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import novamachina.exnihilosequentia.api.tag.ExNihiloTags;
import novamachina.exnihilosequentia.common.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class UseHammerModifier
extends LootModifier {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    private final Random random = new SecureRandom();

    public UseHammerModifier(@Nonnull LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    public List<ItemStack> doApply(@Nonnull List<ItemStack> generatedLoot, @Nonnull LootContext context) {
        logger.debug("Fired Hammer Modifier");
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        ArrayList<ItemStack> newLoot = new ArrayList<ItemStack>();
        if (tool != null && blockState != null && tool.m_41720_().m_7968_().m_204117_(ExNihiloTags.HAMMER) && ExNihiloRegistries.HAMMER_REGISTRY.isHammerable(blockState.m_60734_())) {
            List<ItemStackWithChance> list = ExNihiloRegistries.HAMMER_REGISTRY.getResult(blockState.m_60734_());
            for (ItemStackWithChance stackWithChance : list) {
                if (!(this.random.nextFloat() <= stackWithChance.getChance()) || stackWithChance.getStack() == ItemStack.f_41583_) continue;
                newLoot.add(stackWithChance.getStack());
            }
        }
        if (!newLoot.isEmpty()) {
            logger.debug("Adding new loot");
            generatedLoot = newLoot;
        }
        logger.debug("Hammer Generated Loot: " + generatedLoot);
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<UseHammerModifier> {
        @Nonnull
        public UseHammerModifier read(@Nonnull ResourceLocation location, @Nonnull JsonObject object, @Nonnull LootItemCondition[] ailootcondition) {
            return new UseHammerModifier(ailootcondition);
        }

        public JsonObject write(@Nonnull UseHammerModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

